/* Software para comunicao serial com o PIC16F628A
   Trabalho de Sistemas Autnomos e Ubquos
   Alunos: Patrcia Teixeira Davet e Maique Correa Garcia
   Professor: Adenauer Yamin
   Data: 13/07/2012
*/

//---------------------------------------------------------------------------

#include <vcl.h>
#pragma hdrstop

#include "MedidorTemperaturaUnit1.h"
//---------------------------------------------------------------------------
#pragma package(smart_init)
#pragma link "CPort"
#pragma link "CPortCtl"
#pragma resource "*.dfm"
TForm1 *Form1;
//---------------------------------------------------------------------------
__fastcall TForm1::TForm1(TComponent* Owner)
        : TForm(Owner)
{
 
  //pega a data atual e escreve no label da data
  Label8->Caption = Date();

}
//---------------------------------------------------------------------------
void __fastcall TForm1::Button1Click(TObject *Sender)
{
 ComPort1->ShowSetupDialog(); //mostra a janela de configurao da comunicao serial        
}
//---------------------------------------------------------------------------

void __fastcall TForm1::Timer1Timer(TObject *Sender)
{
 //pega a hora atual e escreve no label da hora
   Label6->Caption = FormatDateTime("hh:mm:ss", Now());
}
//---------------------------------------------------------------------------

void __fastcall TForm1::BitBtn1Click(TObject *Sender)
{
 ComPort1->Close(); //fecha a comport
}
//---------------------------------------------------------------------------

void __fastcall TForm1::Liga_LEDClick(TObject *Sender)
{

    ComPort1->Open();//abre a comport
    ComPort1->ClearBuffer(true, true); //limpa buffers da serial

    switch (RadioGroup1->ItemIndex)
        {
           case 0:
             ComPort1->Write("&a",2);
             Shape2->Brush->Color=clLime;
             break;
           case 1:
             ComPort1->Write("&a",2);
             Shape3->Brush->Color=clRed;
             break;
        }

    ComPort1->Close(); //fecha a comport
}
//---------------------------------------------------------------------------

void __fastcall TForm1::Desliga_LEDClick(TObject *Sender)
{

    ComPort1->Open();
    ComPort1->ClearBuffer(true, true); //limpa buffers da serial

    switch (RadioGroup1->ItemIndex)
        {
           case 0:
             ComPort1->Write("&a",2);
             Shape2->Brush->Color=clGreen;
             break;
           case 1:
             ComPort1->Write("&a",2);
             Shape3->Brush->Color=0x008080FF;
             break;
        }

    ComPort1->Close(); //fecha a comport
}
//---------------------------------------------------------------------------


void __fastcall TForm1::RX_InfoClick(TObject *Sender)
{

    ComPort1->Open();
    ComPort1->ClearBuffer(true, true); //limpa buffers da serial
    ComPort1->Write("&i",2);
    //ComPort1->Close(); //fecha a comport

}
//---------------------------------------------------------------------------

void __fastcall TForm1::ComPort1RxChar(TObject *Sender, int Count)
{
   char retorno[15];
   int num_carac;

   num_carac = ComPort1->InputCount();
   // l nmero de bytes disponveis no buffer de entrada da serial
   if (num_carac > 6 && num_carac < 13)
    {
     ComPort1->Read(retorno,num_carac);// pega os bytes
     retorno[num_carac] = 0;

     if(retorno[1]=='N' && retorno[2]=='')
       {
        Edit2->Text = retorno;

        switch (retorno[5])
          {
           case '1':
             Shape9->Brush->Color=clRed;
             break;
           case '2':
             Shape9->Brush->Color=clRed;
             Shape10->Brush->Color=clRed;
             break;
           case '3':
             Shape9->Brush->Color=clRed;
             Shape10->Brush->Color=clRed;
             Shape11->Brush->Color=clRed;
             break;
           case '4':
             Shape9->Brush->Color=clRed;
             Shape10->Brush->Color=clRed;
             Shape11->Brush->Color=clRed;
             Shape12->Brush->Color=clRed;
             break;
           case '5':
             Shape9->Brush->Color=clRed;
             Shape10->Brush->Color=clRed;
             Shape11->Brush->Color=clRed;
             Shape12->Brush->Color=clRed;
             Shape16->Brush->Color=clRed;
             break;
           case '6':
             Shape9->Brush->Color=clRed;
             Shape10->Brush->Color=clRed;
             Shape11->Brush->Color=clRed;
             Shape12->Brush->Color=clRed;
             Shape16->Brush->Color=clRed;
             Shape17->Brush->Color=clRed;
             break;
           case '7':
             Shape9->Brush->Color=clRed;
             Shape10->Brush->Color=clRed;
             Shape11->Brush->Color=clRed;
             Shape12->Brush->Color=clRed;
             Shape16->Brush->Color=clRed;
             Shape17->Brush->Color=clRed;
             Shape18->Brush->Color=clRed;
             break;
           case '8':
             Shape9->Brush->Color=clRed;
             Shape10->Brush->Color=clRed;
             Shape11->Brush->Color=clRed;
             Shape12->Brush->Color=clRed;
             Shape16->Brush->Color=clRed;
             Shape17->Brush->Color=clRed;
             Shape18->Brush->Color=clRed;
             Shape19->Brush->Color=clRed;
             break;
           case '9':
             Shape9->Brush->Color=clRed;
             Shape10->Brush->Color=clRed;
             Shape11->Brush->Color=clRed;
             Shape12->Brush->Color=clRed;
             Shape16->Brush->Color=clRed;
             Shape17->Brush->Color=clRed;
             Shape18->Brush->Color=clRed;
             Shape19->Brush->Color=clRed;
             Shape20->Brush->Color=clRed;
             break;
          }

        }

      }
      if(num_carac > 12)
        {
         ComPort1->Read(retorno,num_carac);// pega os bytes
         retorno[num_carac] = 0;

         if(retorno[0]=='T')
           Edit1->Text = retorno;
        }
}

//---------------------------------------------------------------------------

void __fastcall TForm1::Button2Click(TObject *Sender)
{

   int int_num_caracE3;

   ComPort1->Open();
   ComPort1->ClearBuffer(true, true); //limpa buffers da serial

   Edit3->Text="&l=" + ComboBox1->Text;

   int_num_caracE3 = Edit3->GetTextLen();

   if (int_num_caracE3) // se tiver caracteres no Edit ...
     {
       ComPort1->Write(Edit3->Text.c_str(),int_num_caracE3);
     }


 }
//---------------------------------------------------------------------------




