// PPGINFO - UCPel
// Estrutura de Dados
// Analisador de Expresses
// Renato Dilli

#include <stdio.h>
#include <conio.h>
#include <string.h>
#include <ctype.h>
#include <stdlib.h>

#define m 50
#define SUCESSO      0
#define PILHA_CHEIA  1
#define PILHA_VAZIA  2
#define DIVISAO_ZERO 3
#define TRUE  !0
#define FALSE  0

typedef int TDADOS;
typedef struct nodo {
                     TDADOS dado;
                     struct nodo *elo;
                     } TNODO;
typedef struct {
                TNODO *topo;
                }TPILHA;

void Cria_Pilha(TPILHA *p);
int Push(TPILHA *p, TDADOS dado);
int Pop(TPILHA *p, TDADOS *dado);
void Imprime_Erro(int erro);
int Codifica(char ch, TDADOS *valor, TDADOS *op);
int Testa_Expressao(char *s);
int Calcula(int v1, int v2, char op);
void destroi_pilha (TPILHA *p);
void exibe_pilha (int n,TPILHA p);

int main()
{
 TPILHA p1,p2;
 char s[256], tecla;
 int n,i,tipo,erro;
 TDADOS valor,v1,v2,operador,resposta;
 do{
 system("cls");
 printf("Analisador de Expressoes\n");
 printf("\nExpressao: ");
 gets(s);
 n = strlen(s);
 if (n > m)
     {
      printf("ERRO: Expressao muito Longa");
     }
 else
     if (Testa_Expressao(s))
	{
	 Cria_Pilha(&p1);
	 Cria_Pilha(&p2);
	 for (i = 0;i < n;i++)
	     {
	      tipo = Codifica(s[i],&valor,&operador);
	      switch (tipo)
	      {
	       case 1: erro = Push(&p1,valor);
                exibe_pilha(1,p1);
		       break;
	       case 2: erro = Push(&p2,operador);
	            exibe_pilha(2,p2);
		       break;
	       case 3: erro = Pop(&p1,&v2);
		       erro = Pop(&p1,&v1);
		       erro = Pop(&p2,&operador);
		       if (operador == '/' && v2 == 0)
		       {
                    erro = 3;
               }
               else
               {
               		resposta = Calcula(v1,v2,operador);
		            erro = Push(&p1,resposta);
               };
		       break;
	      }
	     }

      if (!erro)erro = Pop(&p1,&resposta);
	  destroi_pilha(&p1);
	  destroi_pilha(&p2);
	  if (erro)
	      Imprime_Erro(erro);
	  else
	      {
	       printf("\nResposta: %d \n",resposta);
	      }
	 }
     else
	 {
	  printf("Erro: Expressao Invalida");
	 }
      printf("\nContinua [S/N]? ");
 do {
     tecla = getchar();
    } while (!strchr("SsNn",tecla));
    getchar();
}while(strchr("Ss",tecla));

}

int Codifica(char ch, TDADOS *valor, TDADOS *op)
{
 int codifica = 4;

 if (ch >= '0' && ch <= '9')
    {
     codifica = 1;
     *valor = ch - 48;
    }
 if (strchr("+-*/",ch))
    {
     codifica = 2;
     *op = ch;
    }
 if (ch == ')')
    codifica = 3;
 return(codifica);
}

int Testa_Expressao(char *s)
{
 int i,n,abre=0,fecha=0,totop=0,abreco=0,fechaco=0;

 n = strlen(s);
 for (i = 0;i < n;i++)
 {
     if (s[i] == '+' || s[i] == '-' || s[i] == '*' || s[i] == '/')
         totop++;
     if (s[i] == '[')
     abreco++;
     if (s[i] == ']')
     fechaco++;
     if (s[i] == '(')
	 abre++;
     else
	 if (s[i] == ')')
	    fecha++;
}
if (abre == fecha && abreco == fechaco && abre == totop)
     return(TRUE);
   else
     return(FALSE);
}

int Calcula(int v1, int v2, char op)
{
 switch (op)
 {
  case '+': return(v1 + v2);
  case '-': return(v1 - v2);
  case '*': return(v1 * v2);
  case '/': return(v1 / v2);
 }
 return(0);
}



void Cria_Pilha(TPILHA *p)
{
p->topo = NULL;
}

int Push(TPILHA *p, TDADOS dado)
{
    TNODO *q;
    q = (TNODO *) malloc(sizeof(TNODO));
    if (q == NULL)
       return (PILHA_CHEIA);
    else
        {
              q -> dado = dado;
              q -> elo = p->topo;
              p->topo = q;
              return(SUCESSO);
              }
}
 
 
int Pop(TPILHA *p, TDADOS *dado)
{
 TNODO *q, *t;
    if(p->topo == NULL)
       return (PILHA_VAZIA);
    else
        {
          q = p -> topo;
          *dado = q -> dado;
          t = q -> elo;
          free (q);
          p -> topo = t;    
          return (SUCESSO);
          }
}


void Imprime_Erro(int erro)
{
 switch (erro)
 {
  case PILHA_CHEIA: printf("\nERRO: Pilha Cheia\n");
		    break;
  case PILHA_VAZIA: printf("\nERRO: Pilha Vazia\n");
		    break;
  case DIVISAO_ZERO: printf("\nERRO: Divisao por 0\n");
            break;
 }
}

void destroi_pilha (TPILHA * p)
{
     TNODO * q, * t;
     if (p -> topo != NULL)
     {
           q = p -> topo;
           while (q != NULL)
           {
                 t = q -> elo;
                 free(q);
                 q = t;
                 }
     p->topo = NULL;
     }
}
void exibe_pilha (int n, TPILHA p)
{
    TNODO * t;
    printf ("Pilha %d: ", n);
    if (p.topo == NULL)
       printf ("vazia\n");
    else
        {
              t = p . topo;
              while (t != NULL)
              {
                    if (t->dado=='+' || t->dado=='-' || t->dado=='*' || t->dado=='/')         
             {            
              printf("%c", char(t->dado));
             } 
             else 
             {
              printf("%d", t -> dado);
             } 
                    
                    t = t -> elo;
                    }
                    printf("\n");
    }
    
}
