// PPGINFO - UCPel
// Estrutura de Dados
// Arvore Binaria AVL
// Renato Dilli

#include <stdio.h>
#include <conio.h>
#include <iostream.h>

typedef struct nodo {
	                  int  dado;
	                  int fb;
                      struct nodo *pai;
	                  struct nodo *dir;
                      struct nodo *esq;
	                } tnodo;

typedef tnodo *tree;

void insere_arvore(tree *t, int dado, bool *atualiza_fb);
void mostra_arvore_preorder(tree t);
void mostra_arvore_inorder(tree t);
void mostra_arvore_postorder(tree t);
void procura_arvore(tree *t, int dado);
void remove_arvore(tree *t, int dado);
int maior(tree *t);
int menor(tree *t);
tree rotacao_esquerda(tree *t);
tree rotacao_direita(tree *t);
tree rotacao_esquerda_direita(tree *t);
tree rotacao_direita_esquerda(tree *t);
tree balanceamento_esquerda(tree *t);
tree balanceamento_direita(tree *t);
void mostra_arvore(tree t,int level);

int main (void)
{
    int dado, op;
    tree t = NULL;
    bool atualiza_fb;
    printf("Arvore Binaria - Balanceamento AVL\n");
    do {
    printf ("[I]nserir, [D]eletar, [M]ostrar, [L]impar ou [F]im: ");
    do {
        op = getchar();
       }while (! strchr("IiDdMmLlFf", op));
      switch(op)
      {
      case 'I':
      case 'i':
           printf ("Valor: ");
           cin >> dado;
           insere_arvore(&t, dado, &atualiza_fb);
           break;
      case 'D':
      case 'd':
           printf("Digite o valor a ser deletado: ");
           cin >> dado;
           remove_arvore(&t,dado);
           break;
      case 'M':
      case 'm':
           printf("\nVisao em Arvore\n");
           mostra_arvore(t,0);
           printf("\nPre-order\n");
           mostra_arvore_preorder (t);
           printf("\nIn-order\n");
           mostra_arvore_inorder (t);
           printf("\nPost-order\n");
           mostra_arvore_postorder (t);
           printf("\n");
           break;
      case 'L':
      case 'l':
           t = NULL;
           printf("\nArvore Excluida!\n");
           break;
      }
  }while (!strchr("Ff",op));
} 

void insere_arvore(tree *t, int dado, bool *atualiza_fb)
{
     if(*t == NULL) {
      *t = (tnodo *) malloc(sizeof(tnodo));
      (*t)->dado = dado;
      (*t)->dir = (*t)->esq = (*t)->pai = NULL;
      (*t)->fb =0;
      atualiza_fb = false;
     }
  	 else {
   	  if ( dado == ((*t)->dado) ) printf("Dado ja foi inserido!\n");
      else 	{
      		if (dado < ((*t)->dado)) {
               insere_arvore (&(*t)->esq,dado,atualiza_fb); 
               if (!(*t)->esq->pai) (*t)->esq->pai = *t;
               if (atualiza_fb) {
                                printf ("Atualizando fb...\n");
                switch ((*t)->fb) {
				case 1:  // Maior altura  direita e n inserido  esquerda
					(*t)->fb = 0;
					atualiza_fb = false ;  // No propagar a atualizao do fb
					break;
				case 0:
					(*t)->fb = -1;  // Altura da esquerda maior que direita.
					break;         // Atualizao do fb deve ser propagada.
				case -1:
					*t = balanceamento_esquerda(t);  // fb = -2 -> Balancear sub-rvore
					printf("Final do balanceamento...\n");
		            atualiza_fb = false;  // No propagar a atualizao do fb
					break;
			  }
           } 
           } 
	  		else  if (dado > ((*t)->dado)) {
              insere_arvore(&(*t)->dir,dado, atualiza_fb);
		      if (!(*t)->dir->pai) (*t)->dir->pai = *t; // Atualiza pai do n inserido
		      if (atualiza_fb) {
                                printf ("Atualizando fb...\n");
			  switch ((*t)->fb) {
				case -1:  // Maior altura  esquerda e n inserido  direita
					(*t)->fb = 0;
					atualiza_fb = false; // No propagar a atualizao do fb
					break;
				case 0:
					(*t)->fb = 1;  // Altura da direita maior que esquerda.
					break;          // Atualizao do fb deve ser propagada.
				case 1:
					*t = balanceamento_direita(t);  // fb = 2 -> Balancear sub-rvore
					printf("Final do balanceamento...\n");
					atualiza_fb = false;  // No propagar a atualizao do fb
					break;
			}
		    }
	     }
		}
   }
}

void mostra_arvore(tree t,int level)
{
	int i ;
  	if ( t )
  	{
      if ( t->dir )
  	     mostra_arvore(t->dir,level+1);
  	      
      for ( i=1 ; i<=level ; i++ ) 
          cout << "     " ;
          
      cout << t->dado << endl;
      if ( t->esq )
      	mostra_arvore(t->esq,level+1);
  	}
}


void mostra_arvore_preorder(tree t)
{
   if(t == NULL) return;
   cout << t->dado << "     ";
   mostra_arvore_preorder(t->esq);
   mostra_arvore_preorder(t->dir);
}    

void mostra_arvore_inorder(tree t)
{
   if(t == NULL) return;
   mostra_arvore_inorder(t->esq);
   cout << t->dado << "     ";
   mostra_arvore_inorder(t->dir);
}          
           
void mostra_arvore_postorder(tree t)
{
   if(t == NULL) return;
   mostra_arvore_postorder(t->esq);
   mostra_arvore_postorder(t->dir);
   cout << t->dado << "     ";
}          

void procura_arvore(tree *t, int dado)
{
    if((*t)->esq == NULL) *t = (*t)->dir;
   	else {
        if ((*t)->dir == NULL) *t = (*t)->esq;
		else (*t)->dado = maior(&(*t)->esq );
	}
}
      
void remove_arvore(tree *t, int dado)
{
	if (*t == NULL) printf("Dado nao esta na arvore!\n");
    else {
         if (dado == ((*t)->dado)) procura_arvore(&(*t),dado);  
        else
		{
	  		if ( dado < ((*t)->dado)) remove_arvore(&(*t)->esq, dado);
	  		else remove_arvore(&(*t)->dir, dado);
		}
   }
}

int maior(tree *t)
{
    if ((*t)->dir != NULL) return (maior(&(*t)->dir));
  	else 	{
  		int y = (*t)->dado;
   	    *t = (*t)->esq;
   	    return y;
        }
}
  	
int menor(tree *t)
{
     if ((*t)->esq == NULL) return (*t)->dado;
     else return(menor(&(*t)->esq)); 
}

tree balanceamento_esquerda(tree *t)
{
	tree temp;
	temp = (*t)->esq;
	if (temp->fb == -1) {
		printf("Rotacao a direita...\n");
		*t = rotacao_direita(t); }
	else {
        printf("Rotacao a esquerda_direita...\n");
		*t = rotacao_esquerda_direita(t); }
	(*t)->fb = 0;
	return *t;
}     
tree balanceamento_direita(tree *t)
{
	tree temp;
	temp = (*t)->dir;
	if (temp->fb == 1) {
		printf("Rotacao a esquerda...\n");
 		*t = rotacao_esquerda(t); }
	else {
	    printf("Rotacao a direita_esquerda...\n");
		*t = rotacao_direita_esquerda(t); }
	(*t)->fb = 0;
	return *t;
}
tree rotacao_esquerda(tree *t) {
	tree temp;
	temp = (*t)->dir;
	(*t)->dir = temp->esq;
	if (temp->esq != NULL)
		temp->esq->pai = *t;
	temp->esq = *t;
	temp->pai = (*t)->pai;
	(*t)->pai = temp;
	(*t)->fb = 0;
	return temp;
}

tree rotacao_direita(tree *t) {
	tree temp;
	temp = (*t)->esq;
	(*t)->esq = temp->dir;
	if (temp->dir != NULL) temp->dir->pai = *t;
	temp->dir = *t;
	temp->pai = (*t)->pai;
    (*t)->pai = temp;
	(*t)->fb = 0;
	return temp;
}

tree rotacao_esquerda_direita(tree *t) {
	tree pai;
	tree no_esq;
	tree novo_no;
	int fb_fdir;
	pai = (*t)->pai;
	no_esq = (*t)->esq;
	fb_fdir = no_esq->dir->fb;
	(*t)->esq = rotacao_esquerda(&no_esq);
	novo_no = rotacao_direita(t);
	novo_no->pai = pai;
	(*t)->fb = (fb_fdir == (-1)) ? 1 : 0;
	no_esq->fb = (fb_fdir == 1) ? (-1) : 0;
	return novo_no;
}

tree rotacao_direita_esquerda(tree *t) {
    tree pai;
	tree no_dir;
	tree novo_no;
	int fb_fesq;
	pai = (*t)->pai;
	no_dir = (*t)->dir;
	fb_fesq = no_dir->esq->fb;
	(*t)->dir = rotacao_direita(&no_dir);
	novo_no = rotacao_esquerda(t);
	novo_no->pai = pai;
	(*t)->fb = (fb_fesq == 1) ? (-1) : 0;
	no_dir->fb = (fb_fesq == (-1)) ? 1 : 0;
	return novo_no;
}
