// PPGINFO - UCPel
// Estrutura de Dados
// Arvore Binaria
// Renato Dilli

#include <stdio.h>
#include <conio.h>
#include <iostream.h>

typedef struct nodo {
	                  int  dado;
	                  struct nodo *dir;
                      struct nodo *esq;
	                } tnodo;

typedef tnodo *tree;

void insere_arvore(tree *t, int dado);
void mostra_arvore_preorder(tree t);
void mostra_arvore_inorder(tree t);
void mostra_arvore_postorder(tree t);
void procura_arvore(tree *t, int dado);
void remove_arvore(tree *t, int dado);
int maior(tree *t);
int menor(tree *t);

int main (void)
{
    int dado, op;
    tree t = NULL;
    do {
    printf ("Arvore Binaria - [I]nserir, [D]eletar, [M]ostrar ou [F]im: ");
    do {
        op = getchar();
       }while (! strchr("IiDdMmFf", op));
      switch(op)
      {
      case 'I':
      case 'i':
           printf ("Valor: ");
           cin >> dado;
           insere_arvore(&t, dado);
           break;
      case 'D':
      case 'd':
           printf("Digite o valor a ser deletado: ");
           cin >> dado;
           remove_arvore(&t,dado);
           break;
      case 'M':
      case 'm':
           printf("Pre-order\n");
           mostra_arvore_preorder (t);
           printf("\nIn-order\n");
           mostra_arvore_inorder (t);
           printf("\nPost-order\n");
           mostra_arvore_postorder (t);
           printf("\n");
           break;
      }
  }while (!strchr("Ff",op));
} 

void insere_arvore(tree *t, int dado)
{
     if(*t == NULL) {
      *t = (tnodo *) malloc(sizeof(tnodo));
      (*t)->dado = dado;
      (*t)->dir = (*t)->esq = NULL;
    }
  	else {
   	  if ( dado == ((*t)->dado) ) printf("Dado ja foi inserido!\n");
      else 	{
      		if (dado < ((*t)->dado)) insere_arvore (&(*t)->esq,dado); 
      		
	  		else insere_arvore(&(*t)->dir,dado);
		}
   }
}

void mostra_arvore_preorder(tree t)
{
   if(t == NULL) return;
   cout << t->dado << "     ";
   mostra_arvore_preorder(t->esq);
   mostra_arvore_preorder(t->dir);
}    

void mostra_arvore_inorder(tree t)
{
   if(t == NULL) return;
   mostra_arvore_inorder(t->esq);
   cout << t->dado << "     ";
   mostra_arvore_inorder(t->dir);
}          
           
void mostra_arvore_postorder(tree t)
{
   if(t == NULL) return;
   mostra_arvore_postorder(t->esq);
   mostra_arvore_postorder(t->dir);
   cout << t->dado << "     ";
}          

void procura_arvore(tree *t, int dado)
{
    if((*t)->esq == NULL) *t = (*t)->dir;
   	else {
        if ((*t)->dir == NULL) *t = (*t)->esq;
		else (*t)->dado = maior(&(*t)->esq );
	}
}
      
void remove_arvore(tree *t, int dado)
{
	if (*t == NULL) printf("Dado nao esta na arvore!\n");
    else {
         if (dado == ((*t)->dado)) procura_arvore(&(*t),dado);  
        else
		{
	  		if ( dado < ((*t)->dado)) remove_arvore(&(*t)->esq, dado);
	  		else remove_arvore(&(*t)->dir, dado);
		}
   }
}

int maior(tree *t)
{
//    if ((*t)->dir == NULL) return (*t)->dado;
//    else return (maior(&(*t)->dir)); 
    if ((*t)->dir != NULL) return (maior(&(*t)->dir));
  	else 	{
  		int y = (*t)->dado;
   	    *t = (*t)->esq;
   	    return y;
        }
}
  	
int menor(tree *t)
{
     if ((*t)->esq == NULL) return (*t)->dado;
     else return(menor(&(*t)->esq)); 
}
