# ubiMeter: uma Proposta de Instrumento para o Cenário da IoT

* Lucas Xavier, Patrícia Davet, Prof. Adenauer Yamin
* Laboratory of Ubiquitous and Parallel Systems, Grupo de Pesquisa em Processamento Paralelo e Distribuído
* {lmdsxavier, ptdavet, adenauer}@inf.ufpel.edu.br
* Abril de 2016


## Introdução

1. IoT
2. Instrumentação remota
3. Consciência ao contexto
4. Resumo

**Internet das Coisas**
 * Objetos inteligentes: sensoriamento, comunicação, processamento
 * Infraestrutura da Internet
 * *Internet of Things* ou IoT
 * Desafios: escalabilidade, privacidade, heterogeneidade

**Instrumentação remota**
 * Desafios: acesso remoto, processamento inteligente dos dados, número de dispositivos e heterogeneidade
 * Escopo: automação industrial, laboratórios para ensino e pesquisa

**Computação Consciente ao Contexto**
 * Contexto: informação sobre uma entidade
 * Entidade: pessoa, lugar ou objeto -- relevante para a interação usuário-aplicação
 * Informação: localização, identidade, atividade

**ubiMeter**
 * Instrumento de medição voltado para a IoT
  * Comunicação sem fio
  * Integração ao *middleware* EXEHDA
 * Prototipação e cenários de avaliação


## Middleware EXEHDA

1. Visão geral
2. Subsistema de Reconhecimento ao Contexto e Adaptação
3. Caracterização do ubiMeter

**Middleware EXEHDA**
 * *Execution Environment for Highly Distributed Applications*
 * *Middleware* baseado em serviços
 * Cria e gerencia um ambiente ubíquo
 * Promove a execução de aplicações que expressam a semântica siga-me
 * Aplicações distribuídas, móveis, adaptativas, de alta disponibilidade

**Subsistema de Reconhecimento e Adaptação ao Contexto**
 * Três camadas
   1. *Gateways*
   2. Servidores de Borda
   3. Servidores de Contexto
 // Caracterizar o ubiMeter como gateway

[Imagem da arquitetura do SRAC]

## Concepção e prototipação do ubiMeter

1. Arquitetura {geral, módulo de condicionamento, módulo de controle}
2. Prototipação {do módulo de condicionamento, do módulo de controle, aplicação pc}

**Arquitetura**
 * Hardware modular para aquisição
   1. Módulo de condicionamento
   2. Módulo de controle
 * Software de virtualização
   1. EXEHDA
   2. Aplicação específica
 * Comunicação sem fio
   1. Bluetooth
   2. Wi-Fi

[Imagem da arquitetura do ubiMeter]

**Módulo de Condicionamento**
 * Abstração das especificidades do transdutor
 * Ajuste das características do sinal de entrada

**Módulo de Controle**
 * Digitalização do sinal
 * Interfaces de configuração e leitura

**Prototipação e tecnologias**
 * Voltímetro DC
 * Premissas:
   1. Ampla faixa de operação
   2. Operação autônoma
 * Módulo de Condicionamento // Quebrar para outro slide
   1. Circuito analógico linear
   2. Entrada até 350 V
   3. Quatro faixas de operação: 2 V, 20 V, 200 V e 400 V
   4. *Autorange*
 * Módulo de Controle
   1. PIC18F
   2. Módulos HC-05 e ESP8266
   3. Protocolo CoAP


## Validação

1. Monitoramento da tensão do fotoresistor
2. Precisão e exatidão do h/w de aquisição

**Cenário 1: coleta de dados de intensidade de iluminação**
 * Integração com o EXEHDA
 * Monitoramento da tensão sobre um fotoresistor
 * Período de cinco dias
 * Servidor de Borda: Raspberry Pi
 * Servidor de Contexto remoto
 * Aplicação web baseada em Davet et al. (2015)

[Imagem da aplicação web]

**Cenário 2: desempenho do hardware de aquisição**
 * Comparação com multímetro ET-1002
 * Quinze tensões de referência
 * Trinta repetições

[Tabela erros x faixa de medição]


## Considerações finais

1. Conclusões
2. Trabalhos futuros

**Conclusões**
 * Convergência de desafios entre IoT e instrumentação moderna
 * Integração entre sistemas de instrumentação e *middleware* por meio de *gateways*
 * Prototipação e avaliação do instrumento proposto
 * Expectativa de continuidade

**Trabalhos Futuros**
 * Uso de formato de dados baseado em ontologias estabelecidas
 * Uso de múltiplos protocolos de comunicação
 * Realização de estudos de caso

**Referências**

[Incluir referências]
