package form;

import conexao.ConexaoHttp;
import javax.microedition.io.HttpConnection;
import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.CommandListener;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Form;
import javax.microedition.lcdui.Image;
import javax.microedition.lcdui.ImageItem;
import javax.microedition.lcdui.TextField;
import midlet.CNF;

public class ComunicacaoServidorWeb extends Form implements CommandListener, Runnable {
    
    private CNF frmPrincipal   = null;
    private String tfUrl       = "http://localhost/tcc/index.php";
    private Command commVoltar = null,
            commContribuicao, commDados, commInformativo = null;
    private TextField tfCodigo  = null,
            tfCPF  = null;
    private Thread commThread   = null;
    private HttpConnection http = null;
    private Command commCaptura = null;
    private ConexaoHttp conexaoServer = null;
    
    
    public ComunicacaoServidorWeb(String titulo, CNF frmLogin, int op) {
        super(titulo);
        this.frmPrincipal = frmLogin;
        
       if (op!=2)
       {    
        append(tfCodigo = new TextField("Cdigo:", "",11, TextField.ANY));
        append(tfCPF = new TextField("CPF:      ", "",11, TextField.ANY));
       }  
            addCommand(commVoltar = new Command("Voltar",Command.EXIT,1));
        if (op==0)
            addCommand(commDados = new Command("Acessar",Command.OK,1));
        if (op==1)
            addCommand(commContribuicao = new Command("Acessar",Command.OK,1));
        if (op==2)
            addCommand(commInformativo  = new Command("Acessar",Command.OK,1));
        try{
            Image image = Image.createImage("/imagem/jug_patch.gif");
            append(new ImageItem(null,image,ImageItem.LAYOUT_CENTER,null));
        }catch (Exception e) {}
        setCommandListener(this);
    }
    
    public void commandAction(Command c, Displayable s){
        synchronized (this) {
            if (commThread != null) {return;}
            commCaptura = c;
            commThread = new Thread(this);
            commThread.start();
        }
    }
    
    public void run() {
        if (commCaptura == commVoltar) {
            frmPrincipal.alteraFormulario().popForm();
        } else if (commCaptura == commContribuicao) {
            try{
                conexaoServer = new ConexaoHttp(tfUrl);
                
                if (conexaoServer.processoRmsPOST(("status=contribuicao&codigo="+tfCodigo.getString()+"&cpf=" + tfCPF.getString()).getBytes())){
                    if (conexaoServer.retornoConexao().equals(""))
                        msg("Cdigo/CPF Invlido(s)");
                    else{
                        msg("Relatrio de contribuio:\n" + conexaoServer.retornoConexao());
                    }
                } else msg("Falha na autenticao do Login!");
            }finally{conexaoServer = null;}
        } else if (commCaptura == commDados) {
            try{
                conexaoServer = new ConexaoHttp(tfUrl);
                
                if (conexaoServer.processoRmsPOST(("status=dados&codigo="+tfCodigo.getString()+"&cpf=" + tfCPF.getString()).getBytes())){
                    if (conexaoServer.retornoConexao().equals(""))
                        msg("Cdigo/CPF Invlido(s)");
                    else{
                        msg("Dados cadastrais:\n" + conexaoServer.retornoConexao());
                    }
                } else msg("Falha na autenticao do Login!");
            }finally{conexaoServer = null;}
        }else if (commCaptura == commInformativo) {
            try{
                conexaoServer = new ConexaoHttp(tfUrl);
                if (conexaoServer.processoRmsPOST(("status=info").getBytes())){
                    if (conexaoServer.retornoConexao().equals(""))
                        msg("Cdigo/CPF Invlido(s)");
                    else{
                        msg("Informativo:\n\n" + conexaoServer.retornoConexao());
                    }
                } else msg("Falha na autenticao do Login!");
            }finally{conexaoServer = null;}
        }
        synchronized (this) {commThread = null;}
    }
    
    private void msg(String msg){
        frmPrincipal.alerta(msg, this);
    }
    
}