package conexao;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.microedition.io.Connector;
import javax.microedition.io.HttpConnection;

public class ConexaoHttp {
    
    private String url    = null;
    private String result = null;
    
    public ConexaoHttp(String url){
        this.url = url;
    }
    
    public boolean processoRmsPOST(byte[] dados)  {
        
        HttpConnection httpConexao = null;
        OutputStream oStrm = null;
        InputStream iStrm = null;
        boolean valorRetorno = false;
        try{
            try{
                httpConexao = (HttpConnection)Connector.open(this.url);
                httpConexao.setRequestMethod(HttpConnection.POST);
                httpConexao.setRequestProperty("Content-Type", "application/x-www-form-urlencoded");//Esta linha e obrigatoria para o metodo POS, isso indica que os dados esto indo separados da URL.
                oStrm = httpConexao.openOutputStream();
                oStrm.write(dados);
                iStrm = httpConexao.openInputStream();
                valorRetorno =  processServerResponse(httpConexao, iStrm);
            } finally{
                if (iStrm != null) iStrm.close();
                if (oStrm != null) oStrm.close();
                if (httpConexao != null) httpConexao.close();
            }
            if (valorRetorno == false){}
        } catch(Exception e){}
        
        return valorRetorno;
        
    }
    
    private boolean processServerResponse(HttpConnection  httpConexao, InputStream dados) throws IOException {
        result = "";
        
        if ( httpConexao.getResponseCode() == HttpConnection.HTTP_OK ) {
            String urlNew = httpConexao.getHeaderField("Custom-newURL");
            if (urlNew != null)
                this.url = urlNew;
            int length = (int) httpConexao.getLength();
            
            String str = "";
            if (length != -1) {
                byte servletData[] = new byte[length];
                dados.read(servletData);
                str = new String(servletData);
            }else{
                ByteArrayOutputStream bStrm = new ByteArrayOutputStream();//isso serve para que quando tiver um retorno muito grande ele vai lendo e armazenando em uma array de bytes.
                int posicao = 0;
                while ((posicao = dados.read()) != -1) {
                    bStrm.write(posicao);
                    str = new String(bStrm.toByteArray());
                    bStrm.close();
                }
            }result = str;
            return true;
        }else return false;
    }
    
    public String retornoConexao(){
        return result;
    }
}