package midlet;

import form.ModelFormulario;
import form.ComunicacaoServidorWeb;
import java.io.InputStream;
import javax.microedition.io.Connector;
import javax.microedition.io.StreamConnection;
import javax.microedition.midlet.*;
import javax.microedition.lcdui.*;


public class CNF extends MIDlet implements CommandListener {
    
    private Display display = null;
    private Form formMaim   = null;
    private Image image     = null;
    private Alert alerta    = null;
    private Command commExit, commContribuicao,
            commDadosCadastrais, commInformativos, commHelp;
    private ModelFormulario modelFormulario = null;
    
    
    public CNF(){
        display  = Display.getDisplay(this);
        formMaim = new Form( "Centro Nacional de Formao da RCC-BR" );
        formMaim.addCommand( commExit = new Command("Sair", Command.EXIT, 0) );
        formMaim.addCommand( commContribuicao = new Command( "Contribuies", Command.OK, 1) );
        formMaim.addCommand( commDadosCadastrais = new Command( "Dados cadastrais",Command.OK, 1) );
        formMaim.addCommand( commInformativos = new Command( "Informativos",Command.OK, 1) );
        //formMaim.addCommand( commInformativos = new Command( "Foto 1",Command.OK, 1) );
        //formMaim.addCommand( commInformativos = new Command( "Foto 2",Command.OK, 1) );
        formMaim.addCommand( commHelp = new Command( "Help",Command.HELP, 1) );
        try{
            image = Image.createImage( "/imagem/Inicial.png" );
        }catch (Exception e) { }
        formMaim.append(new ImageItem(null, image, ImageItem.LAYOUT_CENTER, null) );
        formMaim.setCommandListener(this);
        modelFormulario = ModelFormulario.instancia(display, formMaim);
    }
    
//******************************************************************************
    
    public void startApp() {
        display.setCurrent(formMaim);
    }
    
    public void pauseApp() { }
    
    public void destroyApp(boolean unconditional) { }
    
//******************************************************************************
    
    public void commandAction(Command c, Displayable s){
        if (c == commExit){
            destroyApp(false);
            notifyDestroyed();
        }else if (c == commContribuicao){
            modelFormulario.pushForm( new ComunicacaoServidorWeb("CNF - Controle de Contribuio", this,1));
        }else if (c == commDadosCadastrais){
            modelFormulario.pushForm( new ComunicacaoServidorWeb("CNF - Dados Cadastrais", this,0));
        }else if (c== commInformativos){
            modelFormulario.pushForm( new ComunicacaoServidorWeb("CNF - Informativo", this,2));
        }else if (c == commHelp) alerta(lerArquivoHelp(), formMaim);
    }
    
    private String lerArquivoHelp(){
        try{
            int chr = 0;
            InputStream arquivoHelp = getClass().getResourceAsStream("/ajuda/help.txt");
            StringBuffer stb = new StringBuffer();
            while ((chr = arquivoHelp.read())!= -1)
                stb.append((char)chr);
            return stb.toString();
        }catch (Exception e){
            alerta("Erro ao abrir o arquivo de ajuda!", formMaim);
        }
        return null;
    }
    
    public ModelFormulario alteraFormulario(){
        return modelFormulario;
    }
    
    public void alerta(String mensagem, Form frm){
        try{
            Image img = Image.createImage("/imagem/Duke.png");
            alerta = new Alert("Centro Nacional de Formao da RCC-BR", mensagem, img,null);
            alerta.setTimeout(Alert.FOREVER);
            display.setCurrent(alerta, frm);
        }catch (Exception e){}
    }
}